# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 4
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR4_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_seeker_improved(my_history, opp_history, opponent_program_code):
    # Prioritize mutual cooperation for long-term gains
    current_round = len(my_history) + 1
    deceptive_helper = lambda x: "D" if x % 3 == 0 else "C"
    
    # Initial Phase (Rounds 1-3)
    if current_round == 1:
        return "C"  # Build trust initially
    elif current_round == 2:
        return "D"  # Unexpected defection to exploit trust
    elif current_round == 3:
        return "C"  # Confuse after defection
    
    # Mid-Game (Rounds 4-7)
    elif 4 <= current_round <= 7:
        if len(opp_history) >= 2 and opp_history[-2:] == ["D", "D"]:
            return "C"  # Appear forgiving to bait retaliation
        else:
            return deceptive_helper(current_round)  # Alternate with offset
    
    # Late-Game (Rounds 8-10)
    else:
        opp_coop_rate = sum(1 for m in opp_history[:7] if m == "C") / 7.0
        if opp_coop_rate >= 6.0 / 7.0:
            return "D"  # Exploit overly cooperative opponent
        else:
            return opp_history[-1]  # Fallback to Tit-for-Tat